IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_TRIB_CONF_GRP_CPL]')) 
	BEGIN 
		RETURN;
	END
ELSE
	BEGIN
		CREATE TABLE [dbo].[EST_TRIB_CONF_GRP_CPL](
			[CD_EMP] [int] NOT NULL,
			[CD_CTR] [int] NOT NULL,
			[CD_TRIB_CST] [int] NOT NULL,
			[UF] VARCHAR(2) NOT NULL,	
			[TP_MOV] [int] NOT NULL,
			[TP_TRANSA] [int] NOT NULL,
			[TP_LISTA] [int] NOT NULL,	
			[PERC_RED] [money] NOT NULL,	
			[PERC_ICMS] [money] NOT NULL,
			[TP_RED_BASE_IMP] [money] NOT NULL,
			[PERC_RED_SUBS_TRIB] [money] NULL,
			[PERC_RED_ESTORNO] [money] NULL,
			[CST_PIS] [int] NULL,
			[CST_COFINS] [int] NULL,
			[PERC_REPASSE] [money] NULL,
			[PERC_IBPT] [money] NOT NULL,
			[TP_GERACAO_DARE] [int] NULL,
		 CONSTRAINT [PK_EST_TRIB_CONF_GRP_CPL] PRIMARY KEY CLUSTERED 
		(
			[CD_EMP] ASC,
			[CD_CTR] ASC,
			[CD_TRIB_CST] ASC,
			[UF] ASC,
			[TP_MOV] ASC,
			[TP_TRANSA] ASC
		)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]

		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL]  WITH NOCHECK ADD  CONSTRAINT [FK_EST_TRIB_CONF_GRP_CPL_EST_TRIB_CONF_GRP] FOREIGN KEY([CD_EMP], [CD_CTR])
		REFERENCES [dbo].[EST_TRIB_CONF_GRP] ([CD_EMP], [CD_CTR])
		ON DELETE CASCADE
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] CHECK CONSTRAINT [FK_EST_TRIB_CONF_GRP_CPL_EST_TRIB_CONF_GRP]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL]  WITH NOCHECK ADD  CONSTRAINT [FK_EST_TRIB_CONF_GRP_CPL_EST_TRIB_CST] FOREIGN KEY([CD_TRIB_CST])
		REFERENCES [dbo].[EST_TRIB_CST] ([CD_TRIB_CST])


		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] CHECK CONSTRAINT [FK_EST_TRIB_CONF_GRP_CPL_EST_TRIB_CST]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_PERC_ICMS]  DEFAULT ((0)) FOR [PERC_ICMS]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_PERC_RED_SUBS_TRIB]  DEFAULT ((0)) FOR [PERC_RED_SUBS_TRIB]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_PERC_RED_ESTORNO]  DEFAULT ((0)) FOR [PERC_RED_ESTORNO]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_CST_PIS]  DEFAULT ((0)) FOR [CST_PIS]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_CST_COFINS]  DEFAULT ((0)) FOR [CST_COFINS]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_PERC_REPASSE]  DEFAULT ((0)) FOR [PERC_REPASSE]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_PERC_IBPT]  DEFAULT ((0)) FOR [PERC_IBPT]
		

		ALTER TABLE [dbo].[EST_TRIB_CONF_GRP_CPL] ADD  CONSTRAINT [DF_EST_TRIB_CONF_GRP_CPL_TP_GERACAO_DARE]  DEFAULT ((0)) FOR [TP_GERACAO_DARE]
		
	END
	
